//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Threaded.h"
#include "Main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "IWBaseControl"
#pragma link "IWCompLabel"
#pragma link "IWCompProgressBar"
#pragma link "IWCompText"
#pragma link "IWControl"
#pragma link "IWExtCtrls"
#pragma link "IWHTMLControls"
#pragma link "IWBaseComponent"
#pragma link "IWBaseHTMLComponent"
#pragma link "IWBaseHTMLControl"
#pragma link "IWVCLBaseControl"
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
__fastcall TTestThread::TTestThread():TThread(false)
{
  FLock = new TCriticalSection();
}

__fastcall TTestThread::~TTestThread()
{
  //FreeAndNil(FLock);
  delete FLock;
  FLock=NULL;
}

void __fastcall TTestThread::Execute()
{
int i;

  for (i=0; (i<100) && !Terminated; i++)
    {
    FLock->Enter();
    try {
      FPercentComplete++;
      }
    __finally {
      FLock->Leave();
      }
    Sleep(1000);
    }
  Terminate();
}

int __fastcall TTestThread::GetPercentComplete()
{
int result;

  FLock->Enter();
  try {
    result = FPercentComplete;
    }
  __finally {
    FLock->Leave();
    }
  return result;
}


//---------------------------------------------------------------------------
__fastcall TformThreaded::TformThreaded(TComponent* Owner)
        : TIWAppForm(Owner)
{

}
//---------------------------------------------------------------------------

void __fastcall TformThreaded::linkStartClick(TObject *Sender)
{
  linkStart->Visible = false;
  linkBack->Visible = false;
  linkStop->Visible = true;
  IWTimer1->Enabled = true;
  FThread = new TTestThread();
}
//---------------------------------------------------------------------------
void __fastcall TformThreaded::linkStopClick(TObject *Sender)
{
  linkStart->Visible = true;
  linkBack->Visible = true;
  linkStop->Visible = false;
  IWTimer1->Enabled = false;
  lablPercentComplete->Caption = "Thread Stopped";
  FThread->Terminate();
  FThread->WaitFor();
  delete FThread;
  FThread=NULL;
}
//---------------------------------------------------------------------------
void __fastcall TformThreaded::IWTimer1Timer(TObject *Sender)
{
  if (FThread)
    {
    IWProgressBar1->Percent = FThread->PercentComplete;
    lablPercentComplete->Caption = AnsiString("Percent Complete: ") + IntToStr(IWProgressBar1->Percent) + "%";
    if (FThread->IsTerminated)
      linkStopClick(Sender);
    }
}
//---------------------------------------------------------------------------
void __fastcall TformThreaded::linkBackClick(TObject *Sender)
{
TIWAppForm *mf;

  Release();
  mf=new TformMain(WebApplication);
  mf->Show();
}
//---------------------------------------------------------------------------
